/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Slow, Heavy Photons by eiffie
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// V2 Corrected the direction of the gravity lens after seeing https://www.shadertoy.com/view/lls3W8

const float FudgeFactor=0.65;
const int MarchSteps=78;
const vec3 lightDir=vec3(0.577,0.577,-0.577);

#define time iGlobalTime*0.3

float t;//this is time into past
vec3 trans(vec3 p){//transform the point p to its past position
	float t2=time*10.0-t;//the current time minus the time it has taken photons to get from here
	p-=vec3(cos(t2*0.35),0.0,sin(t2*0.35));
	float ct=cos(t2*0.2),st=sin(t2*0.2);
	p.xz=mat2(ct,-st,st,ct)*p.xz;return p;
}
float DE(in vec3 z0){
	vec3 z=abs(trans(z0));
	if(z.x<z.y)z.xy=z.yx;
	if(z.x<z.z)z.xz=z.zx;
	float x2=abs(z.x-2.0);
	return min(max(z.x-2.0,max(z.y-0.1,z.z-0.1)),length(vec3(x2,z.yz))-0.25);
}
void Deflect(in vec3 ro, inout vec3 rd){//change the photon's direction due to gravity
	vec2 ve=vec2(DE(ro),0.0);//find the direction of the object
	vec3 nor=normalize(vec3(-DE(ro-ve.xyy)+DE(ro+ve.xyy),-DE(ro-ve.yxy)+DE(ro+ve.yxy),-DE(ro-ve.yyx)+DE(ro+ve.yyx)));
	if(nor!=nor)nor=0.001*rd;//something went terribly wrong so fake it
	rd=normalize(rd-nor/max(ve.x*ve.x*10.0,200.0));//apply gravity (but not too much!)
}

vec3 getBackground( in vec3 rd ){
	return texture2D(iChannel0,vec2(atan(rd.z,rd.x),rd.y)).rgb;
	//return vec3(0.0,pow(max(abs(sin(atan(rd.z,rd.x)*15.0)),abs(sin(rd.y*20.0))),128.0),0.0);
}

vec3 scene( vec3 ro, vec3 rd )
{// find color of scene
	vec3 col=vec3(0.0);
	float d;
	t=0.0;
	for(int i=0;i<MarchSteps;i++){
		if(t>7.0)continue;
		t+=d=DE(ro)*FudgeFactor;
		ro+=rd*d;
		Deflect(ro,rd);
	}
	if(d<0.01){
		vec2 ve=vec2(0.001,0.0);
		vec3 nor=normalize(vec3(-DE(ro-ve.xyy)+DE(ro+ve.xyy),-DE(ro-ve.yxy)+DE(ro+ve.yxy),-DE(ro-ve.yyx)+DE(ro+ve.yyx)));
		if(nor!=nor)nor=-rd;
		col=vec3(0.5,0.9,0.6)*(0.25+max(0.0,dot(nor,lightDir)*0.75));
		col+=vec3(1.0,0.7,0.4)*max(0.0,pow(dot(lightDir,reflect(rd,nor)),8.0));
	}else{
		col=getBackground(rd);
	}
	return col;
}	 

const float c=0.921,s=0.389;
void main() {
	vec3 rd=vec3((2.0*gl_FragCoord.xy-iResolution.xy)/iResolution.y,1.0);
	rd.yz=mat2(c,s,-s,c)*rd.yz;
	vec3 color=scene(vec3(0.0,1.5,-3.75),normalize(rd));
	if(color!=color)color=vec3(0.0,1.0,0.0);
	gl_FragColor = vec4(clamp(color,vec3(0.0),vec3(1.0)),1.0);
}
